/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.account;

import Krasnodar.rockstarnew.ui.account.Account;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class AccountManager {
    private final List<Account> accounts = new ArrayList<Account>();
    private Account current;
    private final File file;

    public AccountManager() {
        File configsFolder = new File(class_310.method_1551().field_1697, "rockstarnew");
        if (!configsFolder.exists()) {
            configsFolder.mkdir();
        }
        this.file = new File(configsFolder, "accounts.json");
        this.load();
    }

    public void add(Account account) {
        this.accounts.add(account);
        this.save();
    }

    public void remove(Account account) {
        this.accounts.remove(account);
        if (account == this.current) {
            this.current = null;
        }
        this.save();
    }

    public void addAccount(String username) {
        Account account = new Account(username);
        this.add(account);
    }

    public void removeAccount(Account account) {
        this.remove(account);
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public Account getCurrent() {
        return this.current;
    }

    public void select(Account account) {
        this.current = account;
        account.setLastUsed(System.currentTimeMillis());
        this.changeSession(account.getUsername());
        this.save();
    }

    public void toggleFavorite(Account account) {
        account.setFavorite(!account.isFavorite());
        this.save();
    }

    private void changeSession(String username) {
        class_310 mc = class_310.method_1551();
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes());
        class_320 newSession = new class_320(username, uuid, "", Optional.empty(), Optional.empty(), class_320.class_321.field_1990);
        try {
            Field sessionField = class_310.class.getDeclaredField("session");
            sessionField.setAccessible(true);
            sessionField.set(mc, newSession);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void save() {
        try {
            if (!this.file.exists() && !this.file.createNewFile()) {
                throw new IOException("Failed to create accounts file: " + this.file.getAbsolutePath());
            }
            JsonObject json = new JsonObject();
            JsonArray accountsArray = new JsonArray();
            for (Account account : this.accounts) {
                JsonObject accountObject = new JsonObject();
                accountObject.addProperty("username", account.getUsername());
                accountObject.addProperty("favorite", Boolean.valueOf(account.isFavorite()));
                accountObject.addProperty("lastUsed", (Number)account.getLastUsed());
                accountsArray.add((JsonElement)accountObject);
            }
            json.add("accounts", (JsonElement)accountsArray);
            if (this.current != null) {
                json.addProperty("current", this.current.getUsername());
            }
            try (FileWriter writer = new FileWriter(this.file);){
                writer.write(json.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void load() {
        block11: {
            if (!this.file.exists()) {
                return;
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(this.file));){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("accounts")) {
                    JsonArray accountsArray = json.getAsJsonArray("accounts");
                    for (JsonElement element : accountsArray) {
                        JsonObject accountObject = element.getAsJsonObject();
                        String username = accountObject.get("username").getAsString();
                        boolean favorite = accountObject.has("favorite") && accountObject.get("favorite").getAsBoolean();
                        long lastUsed = accountObject.has("lastUsed") ? accountObject.get("lastUsed").getAsLong() : 0L;
                        this.accounts.add(new Account(username, favorite, lastUsed));
                    }
                }
                if (!json.has("current")) break block11;
                String currentUsername = json.get("current").getAsString();
                for (Account account : this.accounts) {
                    if (!account.getUsername().equals(currentUsername)) continue;
                    this.current = account;
                    this.changeSession(account.getUsername());
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

